<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">

    <title>Hello, world!</title>
</head>
<body>
@include('navbar')
<div class="row container mt-3">
    <div class="col-12 col-md-6 my-2 col-lg-4">
        <div class="card">
            <div class="card-header">
                Visits
            </div>
            <div class="card-body">
                <h4>{{\Shetabit\Visitor\Models\Visit::query()->distinct('ip')->count('ip')}}</h4>
            </div>
        </div>
    </div>
    @foreach(\Shetabit\Visitor\Models\Visit::query()->distinct()->get(['platform']) as $platform)
        <div class="col-12 my-2 col-md-6 col-lg-4">
            <div class="card">
                <div class="card-header">{{$platform->platform}}</div>
                <div class="card-body">
                    <h6>{{\Shetabit\Visitor\Models\Visit::query()->where('platform',$platform->platform)->distinct('ip')->count('ip')}}</h6>
                </div>
            </div>
        </div>
    @endforeach
</div>

<div class="row container my-3 mx-3">
    <div class="col-12">
        <table class="table table-sm">
            <thead>
            <tr>
                <th scope="col">IP</th>
                <th scope="col">User Agent</th>
                <th scope="col">Browser</th>
                <th scope="col">Platform</th>
                <th scope="col">Time</th>
            </tr>
            </thead>
            <tbody>
            @foreach(\Shetabit\Visitor\Models\Visit::query()->groupBy(['ip'])->latest()->limit(300)->get() as $data)
                <tr>
                    <th scope="row">{{$data->ip}}</th>
                    <td>{{$data->useragent}}</td>
                    <td>{{$data->browser}}</td>
                    <td>{{$data->platform}}</td>
                    <td>{{$data->created_at}}</td>
                </tr>
            @endforeach

            </tbody>
        </table>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
